typedef struct TagDICKARRAY {
  void* Items;
  int   Count, Capacity, SizeOfItem, Increment;
} DICKARRAY;


extern BOOL DickArrayInit( DICKARRAY* Array, int SizeOfItem,
                                    int InitialCapacity, int Increment );
/*
  this function initializes DICKARRAY structure and allocates memory for
  at least one element, if InitialCapacity is zero;
  the actual capacity may be larger than InitialCapacity;
  Increment is used when array is being reallocated
*/

extern void DickArrayFree( DICKARRAY* Array );

extern BOOL DickArrayGrow( DICKARRAY* Array, int ItemCount );
/*
  allocates space for new items and increases count;
  new space is cleared;
*/

extern BOOL DickArrayAddItem( DICKARRAY* Array, void* Item );
/*
  Item can be NULL - all bytes in allocated space will be set to zero
*/

extern void DickArrayRemoveItems( DICKARRAY* Array,
                                           int ItemIndex, int Count );
/*
  this function removes specified elements from array;
  indexes of subsequent elements will be changed;
  capacity will not decrease
*/

extern void DickArrayShrink( DICKARRAY* Array, int Capacity );
/*
  this function shrinks array to the required capacity or, if required
  capacity is less than item count, to the item count
*/
